# Code for connstructing simulated data for regressions (schools of size between 4 and 50)

# Import packages
import os, sys
import numpy as np
import pandas as pd
import pickle, math
import random 
import scipy.optimize

# Define the average welfare function
def a_welfare(nij,s,DIJ,Thetaij,th): 
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    N=DIJ.shape[0]
    Q=np.sum(np.sum( (( (np.ones((N,N))-np.identity(N))*beta0+Thetaij )*nij -nij*nij/2)*np.outer(np.ones((N,1)),s)-c*nij*DIJ ,axis=0))/N
    return Q

# Define a function that calculates social capital
def augsc(s,Nhat,alpha,Nr):
    M=s.shape[0]
    return s-np.ones((M))-(alpha/Nr)*np.matmul(Nhat,s)

if __name__ == '__main__':

    # Load the data
    with open('spatial_interaction_finaldata_schools4to50.pkl','rb') as f:
        Data=pickle.load(f)
    with open('Xdata_pair_level_Schools4to50.pkl','rb') as f:
        xdata=pickle.load(f)
    # Load the parameter estimates
    with open('II_Results_Schools4to50.pkl','rb') as f:
        Result=pickle.load(f)
    th=Result[0]
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    sig=th[25:26] 
    # Load observed to optimal results
    with open('OPT_OBS_RESULT_stats.pkl','rb') as f:
        Results=pickle.load(f)
    with open('OPT_OBS_RESULT_LIST.pkl','rb') as f:
        Result_LIST=pickle.load(f)
    Nstats_opt=Results[1]
    Sstats_opt=Results[3]
    # Augment observed social capital
    Sstats0_Pred=np.zeros(H)
    Shat0=[]
    for h in range(1,H+1):
        DIJ=D[h-1]
        N=DIJ.shape[0]
        Thetaij=XBc[h-1]-(np.ones((N,N))-np.identity(N))*beta0
        XBij=XBc[h-1] 
        A=SDcell[h-1]
        F=ADcell[h-1] 
        sres0=scipy.optimize.least_squares(augsc,1.01*np.ones(N),args=(A,alpha,N),bounds=(np.ones(N),4*np.ones(N)))
        Sstats0_Pred[h-1]=np.sum(sres0.x)/N
        Shat0.append(sres0.x)
    # Set-up data from lists
    Scell=Data[0]
    SDcell=Data[1]
    Xcell1=Data[2]
    Xcell2=Data[3]
    D=Data[4]
    EPcell=Data[5]
    st_list=Data[6]
    GE=Data[7]
    ADcell=Data[9]
    H=len(Scell) 
    Xcell=[] 
    k1=Xcell1[0].shape[2] 
    for h in range(1,H+1):
        Xcell.append(abs(Xcell1[h-1]))
    R=100
    K=k1*2 
    XBc=[]
    for h in range(1,H+1):
        DIJ=D[h-1]
        N=DIJ.shape[0]
        Xarray1=np.zeros((N,N,K))
        Xarray2=np.zeros((N,N,K))
        X1=Xcell1[h-1]
        X2=Xcell2[h-1]
        for k in range(1,k1+1):
            Xarray1[:,:,k-1]=X1[:,:,k-1]*beta[k-1]
            Xarray2[:,:,k-1]=X2[:,:,k-1]*beta[k1+k-1]
        XBc.append(np.sum(Xarray1,axis=2)+np.sum(Xarray2,axis=2)+(np.ones((N,N))-np.identity(N))*beta0)

    # Calculating variables
    Y=np.zeros((H,5))
    Netm=np.zeros((H,9))
    Xs=np.zeros((H,11))
    for h in range(1,H+1):
        A=SDcell[h-1]
        AS=((A+np.transpose(A))>0)*1
        F=ADcell[h-1]
        FS=((F+np.transpose(F))>0)*1
        DIJ=D[h-1]
        N=A.shape[0]
        Y[h-1,0]=np.mean(Nstats_opt[h-1,:]) 
        Y[h-1,1]=np.sum(np.sum(A*F))/np.sum(np.sum(F)) 
        Y[h-1,2]=np.mean(Sstats_opt[h-1])
        Y[h-1,3]=Sstats0_Pred[h-1] 
        Thetaij=XBc[h-1]-(np.ones((N,N))-np.identity(N))*beta0
        sobs=Shat0[h-1]
        Y[h-1,4]=a_welfare(A,sobs,DIJ,Thetaij,th)
        Netm[h-1,0]=N
        Netm[h-1,1]=N**2
        Netm[h-1,2]=np.sum(np.sum(DIJ))/(N*(N-1))
        Netm[h-1,3]=np.mean(np.sum(FS,axis=1))
        Netm[h-1,4]=np.mean(np.sum(FS,axis=0))
        Netm[h-1,5]=(Netm[h-1,3]+Netm[h-1,4])/2
        Netm[h-1,6]=np.std(np.sum(FS,axis=1))
        Netm[h-1,7]=np.std(np.sum(FS,axis=0))
        Netm[h-1,8]=np.std((np.sum(FS,axis=0)+np.sum(AS,axis=1))/2)
        for t in range(1,12):
            Xp=Xcell2[h-1][:,:,t-1]
            Xs[h-1,t-1]=np.sum(np.sum(Xp))/(2*(N-1)*N)

    Dall=np.concatenate((Y,Netm,Xs),axis=1)
    Dall.shape
    # Export as a csv file
    np.savetxt("Regression_data_schools4to50.csv", Dall, delimiter=",")
